IF EXISTS( SELECT * FROM sys.objects
	WHERE  object_id = OBJECT_ID(N'[dbo].[fnRemoveZeros]')
		   AND type IN(N'FN', N'IF', N'TF', N'FS', N'FT'))
	DROP FUNCTION [dbo].[fnRemoveZeros];
 go
CREATE FUNCTION [dbo].[fnRemoveZeros]
(@TEXTO AS VARCHAR(30), @DIRECAO BIT)
RETURNS VARCHAR(30)
AS
BEGIN
    DECLARE @RETORNO VARCHAR(30)
    IF @DIRECAO = 0 --Remover zeros a esquerda
     SET @RETORNO = SUBSTRING(@TEXTO,PATINDEX('%[a-z,1-9]%',@TEXTO),LEN(@TEXTO))
    ELSE --Remover zeros a direita
     SET @RETORNO = REVERSE(SUBSTRING(REVERSE(@TEXTO),PATINDEX('%[a-z,1-9]%',REVERSE(@TEXTO)),LEN(@TEXTO)))   
    RETURN (@RETORNO)
END
GO